/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.module;

import com.google.gson.Gson;
import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.config.BCConfigFabric;
import com.yungnickyoung.minecraft.bettercaves.json.ResourceLocationAdapter;
import com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion.LiquidRegionsController;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.shedaniel.autoconfig.ConfigHolder;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_2960;

public class ConfigModuleFabric {
    private static final String CUSTOM_CONFIG_PATH = "bettercaves";
    private static final String VERSION_PATH = "fabric-1_21_1";

    public static void init() {
        ConfigModuleFabric.initCustomFiles();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> ConfigModuleFabric.reloadJSON());
    }

    private static class_1269 bakeConfig(ConfigHolder<BCConfigFabric> configHolder, BCConfigFabric configFabric) {
        ConfigModuleFabric.bakeConfig(configFabric);
        ConfigModuleFabric.reloadJSON();
        return class_1269.field_5812;
    }

    private static void initCustomFiles() {
        ConfigModuleFabric.createDirectory();
        ConfigModuleFabric.createBaseReadMe();
        ConfigModuleFabric.createJsonReadMe();
        ConfigModuleFabric.reloadJSON();
    }

    private static void reloadJSON() {
        ConfigModuleFabric.loadLiquidRegionsJSON();
    }

    private static void createDirectory() {
        File parentDir = new File(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH);
        File customConfigDir = new File(parentDir, VERSION_PATH);
        try {
            String filePath = customConfigDir.getCanonicalPath();
            if (customConfigDir.mkdirs()) {
                BetterCavesCommon.LOGGER.info("Creating directory for additional Better Caves config at {}", (Object)filePath);
            }
        }
        catch (IOException e) {
            BetterCavesCommon.LOGGER.error("ERROR creating Better Caves config directory: {}", (Object)e.toString());
        }
    }

    private static void createBaseReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "This directory is for a few additional options for YUNG's Better Caves.\nOptions provided may vary by version.\nThis directory contains subdirectories for supported versions. The first time you run Better Caves, a version subdirectory will be created if that version supports advanced options.\nFor example, the first time you use Better Caves for MC 1.21.1 on Fabric, the 'fabric-1_21_1' subdirectory will be created in this folder.\nIf no subdirectory for your version is created, then that version probably does not support the additional options.";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BetterCavesCommon.LOGGER.error("Unable to create README file!");
            }
        }
    }

    private static void createJsonReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "######################################\n#         liquidregions.json         #\n######################################\n  This file contains the Liquid Regions settings for each dimension.\nWhile the Better Caves carvers are added per-biome, the Liquid Regions\n(i.e. the giant water and lava pools at the bottom of the world) are handled\non a per-dimension basis.\nThe liquidregions.json file is used to define the Liquid Regions for each dimension.\nYou can add or remove dimensions, or modify the settings for existing dimensions.\nIf a dimension is not defined in this file, then it will not have any Liquid Regions.\nIn that case, the normal aquifers will be used instead, as specified in the dimension's\nrespective noise_settings data pack json.\n";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BetterCavesCommon.LOGGER.error("Unable to create Liquid Regions README file!");
            }
        }
    }

    private static void loadLiquidRegionsJSON() {
        Path jsonPath = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "liquidregions.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                LiquidRegionsController.useDefaultSettings();
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)LiquidRegionsController.getInstance());
            }
            catch (IOException e) {
                BetterCavesCommon.LOGGER.error("Unable to create liquidregions.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                BetterCavesCommon.LOGGER.error("Better Caves liquidregions.json file not readable! Using default configuration...");
                LiquidRegionsController.useDefaultSettings();
                return;
            }
            try {
                Gson gson = JSON.newGsonBuilder().registerTypeHierarchyAdapter(class_2960.class, (Object)new ResourceLocationAdapter()).setPrettyPrinting().disableHtmlEscaping().create();
                LiquidRegionsController.INSTANCE = (LiquidRegionsController)JSON.loadObjectFromJsonFile((Path)jsonPath, LiquidRegionsController.class, (Gson)gson);
            }
            catch (IOException e) {
                BetterCavesCommon.LOGGER.error("Error loading Better Caves liquidregions.json file: {}", (Object)e.toString());
                BetterCavesCommon.LOGGER.error("Using default configuration...");
                LiquidRegionsController.useDefaultSettings();
            }
        }
    }

    private static void bakeConfig(BCConfigFabric configFabric) {
    }
}

